﻿* Encoding: UTF-8.
*===================================================================================*
* TÍTULO DE LA SINTAXIS:*
* Cálculo: PROPORCIÓN DE PASAJEROS EXTRANJEROS TRANSPORTADOS POR FERROCARRIL POR CADA MIL QUE INGRESARON AL PAÍS POR MOTIVO DE TURISMO*
* OPERACIÓN ESTADÍSTICA:*
* Anuario de Transporte 2018 - Transporte Ferroviario*
*DIRECCIÓN TÉCNICA RESPONSABLE:*
* Dirección de Estadísticas Económicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadística y Censos (INEC)*
*===================================================================================*
* Fecha de elaboración:         11 de Diciembre del 2018*
* Fecha última modificación:  05 de Septiembre del 2019*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestión de Estadísticas Estructurales (GESE)*.
* Franklin Tenesaca N.
* Gabriela Hidalgo.

*Instrucciones:.
*1.- Descarga la base de datos de Transporte Ferroviario "2018_Transporte_Ferroviario_BDD" en formato SPSS de la página web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2018_Transporte_Ferroviario_BDD".

DATASET NAME FERROCARRILES.
DATASET COPY FERROCARRILES.
DATASET ACTIVATE FERROCARRILES.

**********************************************************************************************************************.
**************PROPORCIÓN DE EXTRANJEROS QUE USARON EL FERROCARRIL*********************.
********************************************POR CADA MIL*******************************************************.
**********************************************************************************************************************.

COMPUTE PASAJEROS=1.
FORMATS PASAJEROS (F10.0).
VARIABLE LABELS PASAJEROS 'Número de pasajeros'.
EXECUTE.

SELECT IF (NACIONALIDAD=2).

***Agregando la base de datos por mes de entrada***.

DATASET DECLARE PASAJEROS.
AGGREGATE
  /outfile='PASAJEROS'
  /break=MES
  /PASAJEROS=SUM(PASAJEROS).

DATASET ACTIVATE PASAJEROS.

VARIABLE LABELS PASAJEROS 'Pasajeros extranjeros transportados por ferrocarril'.
FORMATS PASAJEROS (F10.0).
VARIABLE LEVEL PASAJEROS (SCALE).
EXECUTE.

IF (MES=1) EXTRANJEROS_ESI=161386.
IF (MES=2) EXTRANJEROS_ESI=150532.
IF (MES=3) EXTRANJEROS_ESI=162599.
IF (MES=4) EXTRANJEROS_ESI=143427.
IF (MES=5) EXTRANJEROS_ESI=158561.
IF (MES=6) EXTRANJEROS_ESI=173094.
IF (MES=7) EXTRANJEROS_ESI=196836.
IF (MES=8) EXTRANJEROS_ESI=167436.
IF (MES=9) EXTRANJEROS_ESI=131224. 
IF (MES=10) EXTRANJEROS_ESI=166992.
IF (MES=11) EXTRANJEROS_ESI=137585.
IF (MES=12) EXTRANJEROS_ESI=178940.
EXECUTE.

VARIABLE LABELS EXTRANJEROS_ESI 'Pasajeros extranjeros que ingresaron al país por motivo de turismo'.
FORMATS EXTRANJEROS_ESI (F10.0).
VARIABLE LEVEL EXTRANJEROS_ESI (SCALE).
EXECUTE.

COMPUTE PEXTRANJEROS= (PASAJEROS/(EXTRANJEROS_ESI/1000)).
FORMATS PEXTRANJEROS (F5.0).
VARIABLE LABELS PEXTRANJEROS 'Pasajeros extranjeros transportados en ferrocarril por cada mil extranjeros que ingresaron al país por motivo de turismo'.
EXECUTE.

SORT CASES BY MES (A).


***CUADRO N° 31***.

****POR MES****.

TABLES
/OBSERVATION= EXTRANJEROS_ESI PASAJEROS PEXTRANJEROS
/TABLE=MES BY EXTRANJEROS_ESI + PASAJEROS + PEXTRANJEROS
/STATISTICS=SUM
/TITLE='CUADRO N° 31'
            'PROPORCIÓN DE PASAJEROS EXTRANJEROS TRANSPORTADOS EN FERROCARRIL POR CADA MIL EXTRANJEROS QUE INGRESARON AL PAÍS POR MOTIVO DE TURISMO, año 2018'
            'POR MES'
            '(Número)'
/CAPTION='Elaboración: Instituto Nacional de Estadística y Censos - INEC'
                 'Fuente: INEC - Entradas y Salidas Internacionales - ESI 2018' 
                 'FEEP - Ferrocarriles del Ecuador Empresa Pública 2018'. 	


***DATO NACIONAL***.

DATASET ACTIVATE PASAJEROS.

COMPUTE TOTAL=1.
VALUE LABELS TOTAL 1 'NACIONAL'.
VARIABLE LABELS TOTAL 'TOTAL'.
FORMATS TOTAL (F1.0).
EXECUTE.

DATASET DECLARE NACIONAL.
AGGREGATE
  /outfile='NACIONAL'
  /break=TOTAL
  /PASAJEROS=SUM(PASAJEROS)
  /EXTRANJEROS_ESI=SUM(EXTRANJEROS_ESI).

DATASET ACTIVATE NACIONAL.

VARIABLE LABELS EXTRANJEROS_ESI 'Pasajeros extranjeros que ingresaron al país por motivo de turismo'.
FORMATS EXTRANJEROS_ESI (F10.0).
VARIABLE LEVEL EXTRANJEROS_ESI (SCALE).
EXECUTE.

VARIABLE LABELS PASAJEROS 'Pasajeros extranjeros transportados por ferrocarril'.
FORMATS PASAJEROS (F10.0).
VARIABLE LEVEL PASAJEROS (SCALE).
EXECUTE.

COMPUTE PEXTRANJEROS= (PASAJEROS/(EXTRANJEROS_ESI/1000)).
FORMATS PEXTRANJEROS (F5.0).
VARIABLE LABELS PEXTRANJEROS 'Proporción de pasajeros extranjeros transportados en ferrocarril por cada mil extranjeros que ingresaron al país por motivo de turismo'.
EXECUTE.


TABLES
/OBSERVATION= EXTRANJEROS_ESI PASAJEROS PEXTRANJEROS
/TABLE=TOTAL BY EXTRANJEROS_ESI + PASAJEROS + PEXTRANJEROS
/STATISTICS=SUM
/TITLE='CUADRO N° 31'
            'PROPORCIÓN DE PASAJEROS EXTRANJEROS TRANSPORTADOS EN FERROCARRIL POR CADA MIL EXTRANJEROS QUE INGRESARON AL PAÍS POR MOTIVO DE TURISMO, año 2018'
            'POR MES'
            '(Número)'
/CAPTION='Elaboración: Instituto Nacional de Estadística y Censos - INEC'
                 'Fuente: INEC - Entradas y Salidas Internacionales - ESI 2018' 
                 'FEEP - Ferrocarriles del Ecuador Empresa Pública 2018'. 


DATASET ACTIVATE FERROCARRILES.
DATASET CLOSE PASAJEROS.
DATASET ACTIVATE FERROCARRILES.
DATASET CLOSE NACIONAL.
